unit mVimmICE;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVimmBase, Vcl.StdCtrls, Vcl.ExtCtrls,
  Vcl.ImgList, Vcl.Buttons, System.ImageList, rVimm, Vcl.Grids, OrFn,
  Vcl.ComCtrls;

type
  TfraIce = class(TfraParent)
    pnlIce: TPanel;
    remList: TListView;
    Splitter1: TSplitter;
    remDetails: TRichEdit;
    procedure remListClick(Sender: TObject);
  private
    { Private declarations }
    procedure addToGrid(data: string);
    procedure updateRemMemo(remDetails: TStrings);
    procedure noReminders;
  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
//    destructor Destroy; override;
    procedure collapse;
    procedure populateReminders;
  end;

var
  fraIce: TfraIce;

implementation

{$R *.dfm}

{ TfraIce }

procedure TfraIce.addToGrid(data: string);
var
 lstItem: TListItem;
 strs: TStrings;
 item: TStringList;
 idx: string;
begin
  item := TStringList.create;
  try
  remList.Items.BeginUpdate;
  strs := TStringList.Create;
  idx := Piece(data, U, 1);
  strs.Add(Piece(data, U, 2));
  strs.Add(Piece(data, U, 3));
  strs.Add(Piece(data, U, 5));
  strs.Add(Piece(data, U, 4));
  lstItem := remList.Items.Add;
  lstItem.Caption := idx;
  lstItem.SubItems := strs;
  remList.Items.EndUpdate;
  finally
    item.free;
  end;
end;

procedure TfraIce.collapse;
begin
  if not fCollapsed then spbtnExpandCollapseClick(self);
end;

constructor TfraIce.Create(aOwner: TComponent);
begin
  inherited;
  style := ssPercent;
  minValue := 20;
  if uVimmInputs.isSkinTest then lblHeader.Caption := 'Skin Test Evaluation Statuses:'
  else self.lblHeader.Caption := 'Immunization Evaluation Statuses:';
end;


procedure TfraIce.noReminders;
begin
  if  not fCollapsed then spbtnExpandCollapseClick(self);
  lblHeader.Caption := 'No Evalaution Data Available';
  self.spBtnExpandCollapse.Enabled := false;
end;

procedure TfraIce.populateReminders;
var
remList: TStrings;
i: integer;
temp: string;
begin
  remList := TStringList.Create;
  try
    getReminders(remList, uVimmInputs.isSkinTest);
    if remList.Count = 0 then noReminders;
    for i := 0 to remList.Count - 1 do
      begin
        temp := remList.Strings[i];
        addToGrid(temp);
      end;
  finally
    FreeAndNil(remList);
  end;
end;

procedure TfraIce.remListClick(Sender: TObject);
var
lstItem: TListItem;
rid: string;
remDetails: TStrings;
begin
  inherited;
  if remList.ItemIndex < 0 then
    begin
      ShowMessage('No reminder was selected');
      exit;
    end;
  lstItem := remList.Items.Item[remList.ItemIndex];
//  if lstItem.SubItems.Objects[0] <> nil then
//     begin
//      updateRemMemo(TStrings(lstItem.SubItems.Objects[0]));
//      exit;
//     end;
  rid := lstItem.Caption;
  if rid = '' then
    begin
      ShowMessage('No Reminder ID found.');
      Exit;
    end;
  remDetails := TStringList.Create;
  try
    getReminderMaint(StrToInt(rid), remDetails);
    updateRemMemo(remDetails);
    remList.Items.BeginUpdate;
    lstItem.SubItems.AddObject('remDetails', remDetails);
    remList.Items.EndUpdate;
  finally
    FreeAndNil(remDetails);
  end;

end;

procedure TfraIce.updateRemMemo(remDetails: TStrings);
var
i: integer;
begin
  self.remDetails.Lines.Clear;
//  self.remDetails.Lines.AddStrings(remDetails);
  for I := 0 to remDetails.Count - 1 do
    self.remDetails.Lines.Add(remDetails.Strings[i]);
end;

//destructor TfraIce.Destroy;
//begin
////  pnlIce.Destroy;
////  inherited;
////  if fraIce <> nil then FreeAndNil(fraIce);
//end;

end.
